(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     26489,        909]*)
(*NotebookOutlinePosition[     27420,        940]*)
(*  CellTagsIndexPosition[     27376,        936]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Formal Series Solution\n",
  StyleBox["Regular Singular Point",
    FontSize->14],
  ""
}], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Modified 4/12/98 to be compatible with V 3.0 C. C. Ross
Modified 4/9/2000 to be compatible with V4.0 C. C. Ross
Minor modification to Sum (HoldAll) 4/9/2001 C. C. Ross\
\>", "Text",
  FontSize->10],

Cell[TextData[{
  "This notebook takes advantage of the fact that Sum does not evaluate when \
its terms are unknown. We can therefore perform manipulations on the \
unevaluated arguments. These manipulations parallel those you would perform \
in order to find a series solution manually.\n\nThe ",
  StyleBox["Yellow Boxed",
    FontWeight->"Bold"],
  " cells require special manual attention. ",
  StyleBox["These are places where you can direct the progress of the \
solution",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  ". \n\n",
  StyleBox["Use Shift-Enter to select the next executable cell, and \
Shift-Enter again to execute it.",
    FontVariations->{"Underline"->True}]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["The Differential Operator & Assumed solution, y[x]", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Execute each of the following cells in order. You will have to decide on \
the form of the solution. When Log series are necessary, you can decide on \
the highest power after trying a simple power series solution. Count the \
linearly independent power series solutions that you get. Then decide whether \
or not Log series are needed. \n",
  StyleBox["When asked to evaluate the initialization cells, respond 'Yes'.",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["The Operator and its standard form", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Define your differential operator",
    FontWeight->"Bold"],
  " in the boxed cell below. "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{\(Op[x_, v_]\), "=", 
      RowBox[{
        RowBox[{"x", " ", 
          RowBox[{
            SuperscriptBox["v", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}]}], "+", 
        RowBox[{\((x\^2 + 1)\), " ", 
          RowBox[{
            SuperscriptBox["v", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], 
        "+", \(\((x + 2)\)\ v[x]\)}]}]], "Input",
  CellFrame->True,
  AspectRatioFixed->True,
  Background->RGBColor[0.97586, 1, 0.710002]],

Cell[BoxData[
    RowBox[{\(\((2 + x)\)\ v[x]\), "+", 
      RowBox[{\((1 + x\^2)\), " ", 
        RowBox[{
          SuperscriptBox["v", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{"x", " ", 
        RowBox[{
          SuperscriptBox["v", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}]}]], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["For this notebook to work correctly",
    FontWeight->"Bold"],
  ", the result of executing the next cell MUST be \n             ",
  StyleBox["{ReadProtected}",
    FontFamily->"Courier"],
  ".\n If not, ",
  StyleBox["re-execute the first cell in the Implementation section below and \
check the next cell again",
    FontVariations->{"Underline"->True}],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(FixSum\), "\[IndentingNewLine]", 
    \(Attributes[Sum]\)}], "Input"],

Cell[BoxData[
    \({ReadProtected}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["The function to be substituted", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "This function call generates the proper form for the function to be \
assumed. The symbols in ",
  StyleBox["CoeffList",
    FontWeight->"Bold"],
  " are the names of the coefficients which are to appear in the assumed \
solution. The ",
  Cell[BoxData[
      \(i\^th\)]],
  " name in the list names the coefficients of a series having the form  \n\t\
\t",
  StyleBox["CoeffList[[i]][k] x^(k+r) + Log[x]^(i-1)",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ". \n\n",
  StyleBox[
  "The length of the list in the third parameter determines how many \
Log-power terms occur",
    FontVariations->{"Underline"->True}],
  ". \n\n",
  StyleBox["CoeffList",
    FontWeight->"Bold"],
  " containing a single entry denotes x^r times a simple power series. If \
r=0, x^r===1.\n\nSide-effects: ",
  StyleBox["CoefficientNames ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "is defined globally for subsequent use. The symbol \[Omega] is used \
instead of \[Infinity] as an upper limit because \[Infinity] introduces \
special problems which using \[Omega] avoids. "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Clear[y, r, t, a, b, c, d, e]\)], "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(y[x_] = MakeAssumedFunction[x, r, {a}]\)], "Input",
  CellFrame->True,
  AspectRatioFixed->True,
  Background->RGBColor[0.936004, 1, 0.680003]],

Cell[BoxData[
    \(\[Sum]\+\(k = 0\)\%\[Omega] x\^\(k + r\)\ a[k]\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Substitute y[x] into the operator Op[x, y]", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[FormalSeriesResult]\), "\n", 
    \(FormalSeriesResult[x_] = ReleaseHold[Op[x, y]]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(x\ \(\[Sum]\+\(k = 0\)\%\[Omega]\((\(-1\) + k + r)\)\ \((k + 
                r)\)\ x\^\(\(-2\) + k + r\)\ a[k]\) + \((1 + 
            x\^2)\)\ \(\[Sum]\+\(k = 0\)\%\[Omega]\((k + 
                r)\)\ x\^\(\(-1\) + k + r\)\ a[k]\) + \((2 + 
            x)\)\ \(\[Sum]\+\(k = 0\)\%\[Omega] x\^\(k + r\)\ a[
              k]\)\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Manipulate the Formal Series"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Convert the form of each series or Log series so that zero can be imposed \
by the proper choice of the series coefficients. Remove the factor  x^r. Our \
goal is to force each component in  ",
  StyleBox["FormalPowerSeries ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "to be identically zero. This creates a recursion relation for each \
component. \n\nThe coefficients of the Log series in decreasing powers occur \
before the power series. The power series is always the last (or only) \
component."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(FormalPowerSeries = \ MakeFormalPowerSeries\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({\[Sum]\+\(k = 0\)\%\[Omega]\((k + r)\)\ x\^\(\(-1\) + k\)\ a[
              k] + \[Sum]\+\(k = 0\)\%\[Omega]\((\(-1\) + k + r)\)\ \((k + 
                r)\)\ x\^\(\(-1\) + k\)\ a[k] + \[Sum]\+\(k = 0\)\%\[Omega] 
            2\ x\^k\ a[k] + \[Sum]\+\(k = 0\)\%\[Omega] x\^\(1 + k\)\ a[
              k] + \[Sum]\+\(k = 0\)\%\[Omega]\((k + r)\)\ x\^\(1 + k\)\ a[
              k]}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Determining Set"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Generate the determining set. Look in the recursion relation(s) for the \
properties that it predicts. If there are Log series present, the determining \
set describes the (homogeneous) recursion relation of the coefficients of the \
highest log power. In subsequent recursion relations, the correct form is \
predicted, except that the recursion relation is nonhomogeneous. Look for \
this later."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["DeterminingSet = MakeDeterminingSet", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({\(-1\), 0, 1}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The final series form"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Combine the series in each component into a single sum with some extra \
terms left over. The coefficient of the term of lowest degree in the first \
component, when set to zero, is the ",
  StyleBox["Indicial Equation",
    FontWeight->"Bold"],
  ", from which the indices are obtained.\n\nNote that ",
  StyleBox["subMax",
    FontWeight->"Bold"],
  " and ",
  StyleBox["subMin",
    FontWeight->"Bold"],
  " are Global variables."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(finalSeries = MakeFinalSeries\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({2\ a[0] + \(r\ a[0] + \((\(-1\) + r)\)\ r\ a[0]\)\/x + \((1 + r)\)\ a[
            1] + r\ \((1 + r)\)\ a[
            1] + \[Sum]\+\(k = 1\)\%\[Omega] x\^k\ \((\((k + r)\)\ a[\(-1\) + 
                      k] + 2\ a[
                    k] + \((1 + k + r + \((k + r)\)\ \((1 + k + r)\))\)\ a[
                    1 + k])\)}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The Recursion Relation(s)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Here are the recursion relations for each of the components. The first \
relation determines the coefficients of the highest power Log series. Each \
subsequent relation determines the coefficients of a lower power Log series. \
The last (or only) relation determines the power series coefficients."], 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["RecursionRelation = MakeRecursionRelation", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({{\((k + r)\)\ a[\(-1\) + k] + 
            2\ a[k] + \((1 + k + r + \((k + r)\)\ \((1 + k + r)\))\)\ a[
                1 + k] == 0, k \[GreaterEqual] 1}}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Initial Equations"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "These are the equations that are not explicitly generated by the recursion \
relation(s). The very first one is the ",
  StyleBox["Indicial Equation",
    FontWeight->"Bold"],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["InitialEquations = MakeInitialEquations", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({r\^2\ a[0] == 0, 
      2\ a[0] + a[1] + 2\ r\ a[1] + r\^2\ a[1] == 0}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The Indices"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Solve the ",
  StyleBox["Indicial Equation",
    FontWeight->"Bold"],
  " to get the indices."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(IndicialEquation = Take[InitialEquations, {1}]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({r\^2\ a[0] == 0}\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Manually make an adjustment to the left hand side below",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  ", depending on the order of ",
  StyleBox["IndicialEquation",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " as a polynomial in r. One simple way is to execute the cell once, and \
then adjust so the number of named indices ",
  StyleBox["{r1 ,r2, ...}",
    FontWeight->"Bold"],
  " matches the number of roots.\n\n",
  StyleBox["If the indicial equation",
    FontVariations->{"Underline"->True}],
  " is always ",
  StyleBox["True",
    FontWeight->"Bold"],
  " (as it may be for series centered on an ordinary point), set ",
  StyleBox["r1=0",
    FontWeight->"Bold"],
  " and do not execute the next cell. Then do not use r2."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \({r1, r2} = r /. Solve[IndicialEquation, r]\)], "Input",
  CellFrame->True,
  AspectRatioFixed->True,
  Background->RGBColor[0.936004, 1, 0.680003]],

Cell[BoxData[
    \({0, 0}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Equate Coefficients to 0 (Using n=5)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Choose the number of terms you want in this boxed cell:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(n = 5;\)\)], "Input",
  CellFrame->True,
  AspectRatioFixed->True,
  Background->RGBColor[0.936004, 1, 0.680003]],

Cell[TextData[
"Now that we know the number of coefficients we need to determine, we can \
generate the equations that will be used to determine them and the list of \
unknowns in the required order (back to front)."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\(EquationList[r_] = 
        Join[InitialEquations, 
          Table[AllRecursionRelations[k, r], {k, subMax, n}]];\)\(\n\)
    \)\), "\n", 
    \(TheCoefficients = 
      Join @@ \(\((Table[#1[n - subMin - j], {j, 0, n - subMin}] &)\) /@ 
          Reverse[CoefficientNames]\)\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({a[6], a[5], a[4], a[3], a[2], a[1], a[0]}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The first series solution"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Use the first index to generate (one or more) solutions. Here is where you \
have to be particularly observant. Often two indices will generate the same \
series. Watch carefully for this!  If, after using every index, you still are \
missing some solutions, go back and recalculate with more Log series terms. \
Do this by appending another symbol in the third component of the function \
that generates the assumed function y[x]. Eventually you will get a full \
complement of linearly independent solutions."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(y1[x_] = MakeSeriesSolution[r1] + O[x]^\((n + 2)\)\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(a[0]\), "-", \(2\ a[0]\ x\), "+", \(3\/4\ a[0]\ x\^2\), 
        "+", \(5\/18\ a[0]\ x\^3\), "-", \(101\/576\ a[0]\ x\^4\), 
        "-", \(\(73\ a[0]\ x\^5\)\/2400\), 
        "+", \(\(13501\ a[0]\ x\^6\)\/518400\), "+", 
        InterpretationBox[\(O[x]\^7\),
          SeriesData[ x, 0, {}, 0, 7, 1]]}],
      SeriesData[ x, 0, {
        a[ 0], 
        Times[ -2, 
          a[ 0]], 
        Times[ 
          Rational[ 3, 4], 
          a[ 0]], 
        Times[ 
          Rational[ 5, 18], 
          a[ 0]], 
        Times[ 
          Rational[ -101, 576], 
          a[ 0]], 
        Times[ 
          Rational[ -73, 2400], 
          a[ 0]], 
        Times[ 
          Rational[ 13501, 518400], 
          a[ 0]]}, 0, 7, 1]]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Check", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Expand[Op[x, y1]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[\(O[x]\^6\),
      SeriesData[ x, 0, {}, 6, 6, 1]]], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[
"A second series solution (when r2 != r1) - if needed."], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(FixSum\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(y2[x_] = MakeSeriesSolution[r2] + O[x]^\((n + 2)\)\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(a[0]\), "-", \(2\ a[0]\ x\), "+", \(3\/4\ a[0]\ x\^2\), 
        "+", \(5\/18\ a[0]\ x\^3\), "-", \(101\/576\ a[0]\ x\^4\), 
        "-", \(\(73\ a[0]\ x\^5\)\/2400\), 
        "+", \(\(13501\ a[0]\ x\^6\)\/518400\), "+", 
        InterpretationBox[\(O[x]\^7\),
          SeriesData[ x, 0, {}, 0, 7, 1]]}],
      SeriesData[ x, 0, {
        a[ 0], 
        Times[ -2, 
          a[ 0]], 
        Times[ 
          Rational[ 3, 4], 
          a[ 0]], 
        Times[ 
          Rational[ 5, 18], 
          a[ 0]], 
        Times[ 
          Rational[ -101, 576], 
          a[ 0]], 
        Times[ 
          Rational[ -73, 2400], 
          a[ 0]], 
        Times[ 
          Rational[ 13501, 518400], 
          a[ 0]]}, 0, 7, 1]]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Check second solution"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Expand[Op[x, y2]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[\(O[x]\^6\),
      SeriesData[ x, 0, {}, 6, 6, 1]]], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Implementation (Initialization Cells) ", "Section",
  Evaluatable->False,
  InitializationCell->True,
  AspectRatioFixed->True,
  FontColor->RGBColor[0, 0, 1]],

Cell["\<\
Unprotect[Sum];
FixSum:=ClearAttributes[Sum,HoldAll];\
\>", "Input",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["Define Standard form of operator", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
SetAttributes[StandardOperatorForm, HoldAll]; 
StandardOperatorForm[(L_)[x_, v_]] := 
  L[x, v] /. Derivative[p_][v][x] :> HoldForm[D[v[x], {x, p}]]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Define Assumed Function", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Clear[MakeAssumedFunction]; 
MakeAssumedFunction[x_, r1_:0, CoeffList_List] := 
  Module[{n = Length[CoeffList],r = r1, i,s}, 
  \tOff[Part::pspec];Off[General::spell1];
   CoefficientNames = CoeffList; 
   s=Sum[(CoeffList[[i]][k])*x^(k+r)*Log[x]^(i-1), \t
   \t\t{i,1,Max[n, 1]}];
   \tOn[Part::pspec];On[General::spell1];
   If[TrueQ[Head[s]==Plus],Map[Sum[#,{k,0,\[Omega]} ]&,s],
   \t\tSum[s,{k,0,\[Omega]}]]
   ]
   \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(General::"spell1" \(\(:\)\(\ \)\) 
      "Possible spelling error: new symbol name \"\!\(CoefficientNames\)\" is \
similar to existing symbol \"\!\(CoefficientName\)\"."\)], "Message"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Define Function which Makes Series Solutions", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Clear[MakeSeriesSolution]; 
MakeSeriesSolution[r_] := 
  Module[{rootRules}, Off[Solve::svars];
  rootRules = 
     Solve[Flatten[EquationList[r]],
     \tTheCoefficients, Sort -> False]; 
  On[Solve::svars];
  MakeAssumedFunction[x, r, CoefficientNames]/.\[Omega]\[Rule]n-subMin \
/.rootRules[[1]]]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(MakeFormalPowerSeries := 
      Module[{LogStep1, LogStep2, LogStep3, TheLogParts, step0, step1}, 
        LogStep1 = FormalSeriesResult[x] //. RemoveLogPowers; 
        LogStep2 = LogStep1 //. RemoveSimpleLog; 
        LogStep3 = LogStep2 //. ToIndividualSums; 
        TheLogParts = Reverse[CoefficientList[LogStep3, t]]; 
        step0 = TheLogParts /. RemoveFactor[x, r]; 
        step1 = step0 //. RemoveZeroTerms; 
        step1 //. IncorporateFactors]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(MakeFinalSeries := 
      Module[{step3, step4, step5, step6, step7, step8}, 
        subMax = Max[DeterminingSet]; subMin = Min[DeterminingSet]; 
        step3 = FormalPowerSeries //. AdjustIndices; 
        step4 = step3 /. EqualizeInitialIndices[subMax]; 
        step5 = step4 //. CombineSeries; 
        step6 = step5 /. CollectInitialTerms[x]; 
        step7 = step6 //. CollectSeriesTerms; 
        step8 = step7 //. CollectCoefficientTerms; 
        step8 //. FactorCoefficientTerms]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(MakeDeterminingSet\  := \ \n\ \ Module[{}, \ 
        StepsToList\  = \ \n\ \ \ \ \ Flatten[
            FormalPowerSeries\  //. \ \n\ \ \ \ \ \ \ Plus[
                  Sum[c_, \ {k_, \ 
                        s_, \ \[Omega]}]\  + \ \((e_)\)]\  :> \ \n\ \ \ \ \ \ \
\ \ {Sum[c, \ {k, \ s, \ \[Omega]}], \ e}]; \ \n\ \ \ \ Union[
          StepsToList\  //. \ \n\ \ \ \ \ \ Sum[\((a_. )\)*
                  x^\((\((k_)\)\  + \ \((p_. )\))\), \ {k, \ 
                  s_, \ \[Omega]}]\  :> \ p]\n]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(MakeRecursionRelation\  := \ \n\ \ finalSeries\  /. \ \n\ \ \ \((p_)\)\ \
 + \ Sum[\((c_)\)*\((x_)\)^\((k_)\), \ {k_, \ 
                s_, \ \[Omega]}]\  :> \ \n\ \ \ \ {c\  == \ 0, \ 
            k\  >= \ s}\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(MakeInitialEquations\  := \ \n\ \ Module[{InitialTerms}, \ \n\ \ \ \
AllRecursionRelations[k_, \ 
            r_]\  = \ \n\ \ \ \ \ \(Transpose[
              RecursionRelation]\)[\([1]\)]; \ \n\ \ \ \ InitialTerms\  = \ \n\
\ \ \ \ \ Expand[\((finalSeries\  /. \ \n\ \ \ \ \ \ \ \ \ \((p_)\)\  + \ 
                      Sum[\((c_)\)*\((x_)\)^\((k_)\), \ \n\ \ \ \ \ \ \ \ \ \ \
\ \ {k_, \ s_, \ \[Omega]}]\  :> \ p)\)/
              x^subMin]; \ \n\ \ \ \ \((#1\  == \ 
                0\  &\ )\)\  /@ \ \n\ \ \ \ \ Flatten[
            CoefficientList[InitialTerms, \ x]]]\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Transformation Rules", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(\(AdjustIndices\  = \ \n\ \ \ Sum[\((c_)\)*\((x_)\)^\((\((k_)\)\  + \ \
\((q_)\))\), \ {k_, \ 
              s_, \ \[Omega]}]\  :> \ \n\ \ \ \ Sum[\((c\  /. \ 
                  k\  :> \ k\  - \ q)\)*x^k, \ {k, \ 
              s\  + \ q, \ \[Omega]}];\)\(\ \)\)\)], "Input",
  InitializationCell->True],

Cell["\<\
RemoveLogPowers = 
   (a_.)*Sum[(p1_)*Log[x_]^(q_) + (p2_.), {k_, s_, \[Omega]}] :> 
    a*t^q*Sum[p1, {k, s, \[Omega]}] + a*Sum[p2, {k, s, \[Omega]}]; \
\>", \
"Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
RemoveSimpleLog = 
   (a_.)*Sum[(p1_)*Log[x_] + (p2_.), {k_, s_, \[Omega]}] :> 
    a*t*Sum[p1, {k, s, \[Omega]}] + a*Sum[p2, {k, s, \[Omega]}]; \
\>", \
"Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
ToIndividualSums = 
   (a_.)*Sum[(p1_) + (p2_), {k_, s_, \[Omega]}] :> 
    a*Sum[p1, {k, s, \[Omega]}] + a*Sum[p2, {k, s, \[Omega]}]; \
\>", "Input",\

  InitializationCell->True,
  AspectRatioFixed->True],

Cell["RemoveFactor[x_, r_] = x^((p_) + r) :> x^p; ", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
RemoveZeroTerms = 
   Sum[(c_)*(x_)^(p_), {k_, a_, \[Omega]}] :> 
    Sum[c*x^p, {k, a + 1, \[Omega]}] /; (c /. k -> a) == 0; \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
IncorporateFactors = 
   ((a_.) + (b_))*Sum[c_, {k_, s_, \[Omega]}] :> 
    Sum[a*c, {k, s, \[Omega]}] + Sum[b*c, {k, s, \[Omega]}]; \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
Clear[EqualizeInitialIndices]
EqualizeInitialIndices[subMax_] := 
  Sum[c_, {k_, s_, \[Omega]}] :> 
   Sum[c, {k, s, subMax - 1}] + Sum[c, {k, subMax, \[Omega]}] /; s < subMax\
\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
CombineSeries = 
   Sum[c_, {k_, s_, \[Omega]}] + Sum[d_, {k_, s_, \[Omega]}] :> 
    Sum[c + d, {k, s, \[Omega]}]; \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
CollectInitialTerms[x_] = 
   (p_) + Sum[c_, {k_, s_, \[Omega]}] :> 
    Collect[p, x] + Sum[c, {k, s, \[Omega]}]; \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
CollectSeriesTerms = 
   Sum[(x_)^(k_)*(c1_.) + (x_)^(k_)*(d1_.) + (e1_.), {k_, s_, \[Omega]}] :> 
    Sum[x^k*(c1 + d1) + e1, {k, s, \[Omega]}]; \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
CollectCoefficientTerms = 
   Sum[(x_)^(k_)*((c1_.)*(c_)[p_] + (d1_.)*(c_)[p_] + (e1_.)), 
     {k_, s_, \[Omega]}] :> Sum[x^k*((c1 + d1)*c[p] + e1), {k, s, \[Omega]}]; \
\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
FactorCoefficientTerms = 
   Sum[((c1_)*(c_)[p_] + (c2_)*(c_)[q_] + (c3_.))*x^k, {k_, s_, \[Omega]}] :> \

    Sum[(Factor[c1]*c[p] + Factor[c2]*c[q] + c3)*x^k, {k, s, \[Omega]}]; \
\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{591, 660},
WindowMargins->{{23, Automatic}, {Automatic, 10}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 170, 7, 95, "Subtitle",
  Evaluatable->False],
Cell[1949, 62, 207, 5, 59, "Text"],
Cell[2159, 69, 757, 18, 158, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2941, 91, 117, 2, 56, "Section",
  Evaluatable->False],
Cell[3061, 95, 556, 11, 86, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3642, 110, 104, 2, 46, "Subsection",
  Evaluatable->False],
Cell[3749, 114, 179, 6, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3953, 124, 525, 14, 47, "Input"],
Cell[4481, 140, 374, 9, 29, "Output"]
}, Closed]],
Cell[4870, 152, 403, 11, 68, "Text"],

Cell[CellGroupData[{
Cell[5298, 167, 90, 2, 43, "Input"],
Cell[5391, 171, 49, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5489, 178, 100, 2, 46, "Subsection",
  Evaluatable->False],
Cell[5592, 182, 1153, 32, 212, "Text",
  Evaluatable->False],
Cell[6748, 216, 88, 2, 27, "Input"],

Cell[CellGroupData[{
Cell[6861, 222, 163, 4, 43, "Input"],
Cell[7027, 228, 80, 1, 50, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7168, 236, 109, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7302, 242, 149, 3, 43, "Input"],
Cell[7454, 247, 361, 6, 94, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7864, 259, 105, 2, 36, "Section",
  Evaluatable->False],
Cell[7972, 263, 593, 13, 122, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8590, 280, 102, 2, 27, "Input"],
Cell[8695, 284, 416, 6, 94, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[9160, 296, 92, 2, 36, "Section",
  Evaluatable->False],
Cell[9255, 300, 472, 8, 86, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9752, 312, 78, 1, 27, "Input"],
Cell[9833, 315, 48, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[9930, 322, 98, 2, 36, "Section",
  Evaluatable->False],
Cell[10031, 326, 512, 15, 104, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10568, 345, 88, 2, 27, "Input"],
Cell[10659, 349, 360, 6, 85, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[11068, 361, 102, 2, 36, "Section",
  Evaluatable->False],
Cell[11173, 365, 376, 7, 68, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11574, 376, 84, 1, 27, "Input"],
Cell[11661, 379, 189, 3, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[11899, 388, 94, 2, 36, "Section",
  Evaluatable->False],
Cell[11996, 392, 260, 8, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12281, 404, 82, 1, 27, "Input"],
Cell[12366, 407, 105, 2, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[12520, 415, 88, 2, 36, "Section",
  Evaluatable->False],
Cell[12611, 419, 173, 7, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12809, 430, 105, 2, 27, "Input"],
Cell[12917, 434, 51, 1, 29, "Output"]
}, Closed]],
Cell[12983, 438, 848, 24, 122, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13856, 466, 167, 4, 43, "Input"],
Cell[14026, 472, 40, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[14115, 479, 113, 2, 36, "Section",
  Evaluatable->False],
Cell[14231, 483, 130, 3, 32, "Text",
  Evaluatable->False],
Cell[14364, 488, 135, 4, 43, "Input"],
Cell[14502, 494, 274, 5, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[14801, 503, 341, 8, 107, "Input"],
Cell[15145, 513, 76, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[15270, 520, 102, 2, 36, "Section",
  Evaluatable->False],
Cell[15375, 524, 585, 9, 104, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[15985, 537, 109, 2, 27, "Input"],
Cell[16097, 541, 797, 26, 79, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[16931, 572, 75, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[17031, 578, 76, 2, 27, "Input"],
Cell[17110, 582, 98, 2, 29, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[17269, 591, 131, 3, 36, "Section",
  Evaluatable->False],
Cell[17403, 596, 39, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[17467, 601, 109, 2, 27, "Input"],
Cell[17579, 605, 797, 26, 79, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[18413, 636, 101, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[18539, 642, 76, 2, 27, "Input"],
Cell[18618, 646, 98, 2, 29, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[18777, 655, 165, 4, 36, "Section",
  Evaluatable->False,
  InitializationCell->True],
Cell[18945, 661, 106, 4, 42, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[19076, 669, 102, 2, 46, "Subsection",
  Evaluatable->False],
Cell[19181, 673, 227, 6, 72, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[19445, 684, 93, 2, 30, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[19563, 690, 501, 15, 207, "Input",
  InitializationCell->True],
Cell[20067, 707, 204, 3, 70, "Message"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[20320, 716, 114, 2, 30, "Subsection",
  Evaluatable->False],
Cell[20437, 720, 378, 12, 147, "Input",
  InitializationCell->True],
Cell[20818, 734, 519, 10, 203, "Input",
  InitializationCell->True],
Cell[21340, 746, 552, 11, 187, "Input",
  InitializationCell->True],
Cell[21895, 759, 562, 10, 139, "Input",
  InitializationCell->True],
Cell[22460, 771, 271, 5, 75, "Input",
  InitializationCell->True],
Cell[22734, 778, 636, 11, 171, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[23407, 794, 90, 2, 30, "Subsection",
  Evaluatable->False],
Cell[23500, 798, 325, 6, 59, "Input",
  InitializationCell->True],
Cell[23828, 806, 233, 7, 87, "Input",
  InitializationCell->True],
Cell[24064, 815, 226, 7, 72, "Input",
  InitializationCell->True],
Cell[24293, 824, 216, 7, 57, "Input",
  InitializationCell->True],
Cell[24512, 833, 115, 2, 27, "Input",
  InitializationCell->True],
Cell[24630, 837, 205, 6, 72, "Input",
  InitializationCell->True],
Cell[24838, 845, 212, 6, 57, "Input",
  InitializationCell->True],
Cell[25053, 853, 256, 8, 87, "Input",
  InitializationCell->True],
Cell[25312, 863, 195, 6, 57, "Input",
  InitializationCell->True],
Cell[25510, 871, 194, 6, 57, "Input",
  InitializationCell->True],
Cell[25707, 879, 225, 6, 72, "Input",
  InitializationCell->True],
Cell[25935, 887, 250, 7, 87, "Input",
  InitializationCell->True],
Cell[26188, 896, 261, 8, 87, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

]}] :> 
    Sum[c*x^p, {k, a + 1, \[Omega]}] /; (c /. k -> a) == 0; \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
IncorporateFactors = 
   ((a_.) + (b_))*Sum[c_, {k_, s_, \[Omega]}] :> 
    Sum[a*c, {k, s, \[Omega]}] + Sum[b*c, {k, s, \[Omega]}]; \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
Clear[EqualizeInitialIndices]
EqualizeInitialIndices[subMax_] := 
  Sum[c_, {k_, s_, \[Omega]}] :> 
   Sum[c, {k, s, subMax - 1}] + Sum[c, {k, subMax, \[Omega]}] /; s < subMax\
\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
CombineSeries = 
   Sum[c_, {k_, s_, \[Omega]}] + Sum[d_, {k_, s_, \[Omega]}] :> 
    Sum[c + d, {k, s, \[Omega]}]; \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
CollectInitialTerms[x_] = 
   (p_) + Sum[c_, {k_, s_, \[Omega]}] :> 
    Collect[p, x] + Sum[c, {k, s, \[Omega]}]; \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
CollectSeriesTerms = 
   Sum[(x_)^(k_)*(c1_.) + (x_)^(k_)*(d1_.) + (e1_.), {k_, s_, \[Omega]}] :> 
    Sum[x^k*(c1 + d1) + e1, {k, s, \[Omega]}]; \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
CollectCoefficientTerms = 
   Sum[(x_)^(k_)*((c1_.)*(c_)[p_] + (d1_.)*(c_)[p_] + (e1_.)), 
     {k_, s_, \[Omega]}] :> Sum[x^k*((c1 + d1)*c[p] + e1), {k, s, \[Omega]}]; \
\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
FactorCoefficientTerms = 
   Sum[((c1_)*(c_)[p_] + (c2_)*(c_)[q_] + (c3_.))*x^k, {k_, s_, \[Omega]}] :> \

    Sum[(Factor[c1]*c[p] + Factor[c2]*c[q] + c3)*x^k, {k, s, \[Omega]}]; \
\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{591, 660},
WindowMargins->{{23, Automatic}, {Automatic, 10}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 170, 7, 82, "Subtitle",
  Evaluatable->False],
Cell[1949, 62, 207, 5, 59, "Text"],
Cell[2159, 69, 757, 18, 158, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2941, 91, 117, 2, 69, "Section",
  Evaluatable->False],
Cell[3061, 95, 556, 11, 104, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3642, 110, 104, 2, 38, "Subsection",
  Evaluatable->False],
Cell[3749, 114, 179, 6, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3953, 124, 525, 14, 47, "Input"],
Cell[4481, 140, 374, 9, 28, "Output"]
}, Open  ]],
Cell[4870, 152, 403, 11, 81, "Text"],

Cell[CellGroupData[{
Cell[5298, 167, 90, 2, 43, "Input"],
Cell[5391, 171, 60, 1, 26, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5500, 178, 100, 2, 30, "Subsection",
  Evaluatable->False],
Cell[5603, 182, 1153, 32, 214, "Text",
  Evaluatable->False],
Cell[6759, 216, 88, 2, 27, "Input"],

Cell[CellGroupData[{
Cell[6872, 222, 163, 4, 43, "Input"],
Cell[7038, 228, 80, 1, 50, "Output"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7179, 236, 109, 2, 69, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7313, 242, 149, 3, 43, "Input"],
Cell[7465, 247, 361, 6, 94, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7875, 259, 105, 2, 39, "Section",
  Evaluatable->False],
Cell[7983, 263, 593, 13, 128, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8601, 280, 102, 2, 27, "Input"],
Cell[8706, 284, 1153, 18, 226, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[9908, 308, 92, 2, 39, "Section",
  Evaluatable->False],
Cell[10003, 312, 472, 8, 94, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10500, 324, 78, 1, 27, "Input"],
Cell[10581, 327, 48, 1, 26, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[10678, 334, 98, 2, 39, "Section",
  Evaluatable->False],
Cell[10779, 338, 512, 15, 100, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11316, 357, 88, 2, 27, "Input"],
Cell[11407, 361, 856, 16, 234, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[12312, 383, 102, 2, 39, "Section",
  Evaluatable->False],
Cell[12417, 387, 376, 7, 78, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12818, 398, 84, 1, 27, "Input"],
Cell[12905, 401, 420, 8, 71, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[13374, 415, 94, 2, 39, "Section",
  Evaluatable->False],
Cell[13471, 419, 260, 8, 48, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13756, 431, 82, 1, 27, "Input"],
Cell[13841, 434, 221, 4, 62, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[14111, 444, 88, 2, 39, "Section",
  Evaluatable->False],
Cell[14202, 448, 173, 7, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[14400, 459, 105, 2, 27, "Input"],
Cell[14508, 463, 51, 1, 28, "Output"]
}, Closed]],
Cell[14574, 467, 848, 24, 119, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[15447, 495, 167, 4, 43, "Input"],
Cell[15617, 501, 40, 1, 26, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[15706, 508, 113, 2, 39, "Section",
  Evaluatable->False],
Cell[15822, 512, 130, 3, 30, "Text",
  Evaluatable->False],
Cell[15955, 517, 135, 4, 43, "Input"],
Cell[16093, 523, 274, 5, 62, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[16392, 532, 328, 7, 155, "Input"],
Cell[16723, 541, 125, 2, 41, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[16897, 549, 102, 2, 39, "Section",
  Evaluatable->False],
Cell[17002, 553, 585, 9, 110, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[17612, 566, 109, 2, 27, "Input"],
Cell[17724, 570, 3570, 121, 280, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[21331, 696, 75, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[21431, 702, 76, 2, 27, "Input"],
Cell[21510, 706, 5065, 152, 382, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[26636, 865, 131, 3, 39, "Section",
  Evaluatable->False],
Cell[26770, 870, 39, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[26834, 875, 109, 2, 27, "Input"],
Cell[26946, 879, 797, 26, 79, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[27780, 910, 101, 2, 30, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[27906, 916, 76, 2, 27, "Input"],
Cell[27985, 920, 98, 2, 28, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[28144, 929, 165, 4, 39, "Section",
  Evaluatable->False,
  InitializationCell->True],
Cell[28312, 935, 106, 4, 42, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[28443, 943, 102, 2, 38, "Subsection",
  Evaluatable->False],
Cell[28548, 947, 227, 6, 72, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[28812, 958, 93, 2, 30, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[28930, 964, 501, 15, 207, "Input",
  InitializationCell->True],
Cell[29434, 981, 204, 3, 70, "Message"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[29687, 990, 114, 2, 30, "Subsection",
  Evaluatable->False],
Cell[29804, 994, 378, 12, 147, "Input",
  InitializationCell->True],
Cell[30185, 1008, 519, 10, 203, "Input",
  InitializationCell->True],
Cell[30707, 1020, 552, 11, 187, "Input",
  InitializationCell->True],
Cell[31262, 1033, 562, 10, 139, "Input",
  InitializationCell->True],
Cell[31827, 1045, 271, 5, 75, "Input",
  InitializationCell->True],
Cell[32101, 1052, 636, 11, 171, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[32774, 1068, 90, 2, 30, "Subsection",
  Evaluatable->False],
Cell[32867, 1072, 325, 6, 59, "Input",
  InitializationCell->True],
Cell[33195, 1080, 233, 7, 87, "Input",
  InitializationCell->True],
Cell[33431, 1089, 226, 7, 72, "Input",
  InitializationCell->True],
Cell[33660, 1098, 216, 7, 57, "Input",
  InitializationCell->True],
Cell[33879, 1107, 115, 2, 27, "Input",
  InitializationCell->True],
Cell[33997, 1111, 205, 6, 72, "Input",
  InitializationCell->True],
Cell[34205, 1119, 212, 6, 57, "Input",
  InitializationCell->True],
Cell[34420, 1127, 256, 8, 87, "Input",
  InitializationCell->True],
Cell[34679, 1137, 195, 6, 57, "Input",
  InitializationCell->True],
Cell[34877, 1145, 194, 6, 57, "Input",
  InitializationCell->True],
Cell[35074, 1153, 225, 6, 72, "Input",
  InitializationCell->True],
Cell[35302, 1161, 250, 7, 87, "Input",
  InitializationCell->True],
Cell[35555, 1170, 261, 8, 87, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

